;;************************************************************************
;; brovrly0.lsp 
;; contains code for datasheet overlay
;; copyright (c) 1998-2001 by Forrest W. Young
;;***********************************************************************;


(defproto browser-overlay-proto 
  '(help retain-edit edit-state discard discard-state selector selector-state 
	format expand labels top-most top-state maximize-button-showing max-state  justify)  
   () dash-overlay-proto)



#|
 | button states
 | NIL       - not visible
 | VISIBLE   - visible, non-clickable, gray,  "Edit"
 | READY (T) - visible, clickable,     black, "Edit"  
 | ACTIVE    - visible, clickable,     red,   "Retain" 
 |#

(defmeth datasheet-proto  :browser-buttons
    (&key (margin (list 50 (+ 17 (send graph-proto :text-descent)) 0 0)) (justify t) 
          (help t) (retain-edit 'visible) (discard 'visible) (selector nil) 
          (format 'ready) (expand 'visible) (labels 'visible) (top-most 'ready) (max nil) 
          )
  (when (= *color-mode* 0) (setf color nil)) 
  (send self :add-overlay 
        (send browser-overlay-proto :new :margin margin :justify justify 
              :help help :retain-edit retain-edit :max max :top-most top-most :discard discard
              :expand expand :labels labels :format format :selector selector)))

(defmeth datasheet-proto :dash-buttons
    (&key (margin (list 0 (+ 17 (send self :text-descent)) 0 0)) (justify t)
          (help t) (max t) (expand t) (labels t) (format t) (selector nil)
          (save nil) (lock nil) (discard nil) (top-most t) (justify t)
          )
"Places buttons on datasheets
ARGS: &key (margin (list 0 (+ 17 (send self :text-descent)) 0 0)) 
(help t) (max t) (expand t) (labels t) (format t) (save t) (lock t) (discard t) (top-most t) (selector nil) (justify nil)
Compared to version 6.4 (save t) now shows a retain/edit button that either makes the datasheet editable or retains the datasheet in a dataobject, rather than save data to a file; (discard t) and (top-most t) are new; and (lock t), (pop nil), (refresh t) no longer implemented."
  (send self :add-overlay 
        (send browser-overlay-proto :new :margin margin :justify justify
              :help help :max max :expand expand :labels labels :format format
               :retain-edit save :discard discard :top-most top-most
              :selector selector
              )))


(defmeth datasheet-proto :editor-buttons
    (&key (margin (list 0 (+ 17 (send self :text-descent)) 0 0)) (justify t)
          (help t) (retain-edit 'active) (discard 'active) (selector nil) 
          (format t) (expand t) (labels t) (top-most t) (max nil) 
          )
"Places buttons on datasheets that are appropriate for editor mode.
ARGS: &key (margin (list 0 (+ 17 (send self :text-descent)) 0 0)) 
(help t) (retain nil) (max t) (expand t) (labels t) (format t) (save t) (lock t) (discard t) (top-most t) (selector nil) (justify nil)
Compared to version 6.4 (save t) now shows a edit/retain button that either makes the datasheet editable or retain dob rather than save data; (lock t) now shows an edit/save button; (discard t) and (top-most t) are new; and (pop nil) (refresh t) no longer implemented."
  (send self :add-overlay 
        (send browser-overlay-proto :new :margin margin :justify justify 
               :help help :retain-edit retain-edit  :discard discard
              :expand expand :labels labels :format format 
              :max max :top-most top-most :selector selector)))




(defmeth browser-overlay-proto :isnew 
  (&key (margin (list 50 (+ 17 (send graph-proto :text-descent)) 0 0))
        (justify t) (help t) (retain-edit nil) (max t) (top-most t) 
        (expand nil expand?) (labels nil labels?) (format t) (discard t) (selector nil))
  (let* ((graph (send self :graph)))
    (send self :justify justify)
    (send self :selector selector)
    (send self :help help)
    (send self :retain-edit retain-edit)
    (send self :maximize-button-showing max)
    (send self :top-most top-most)
    (send self :format format) 
    (send self :expand expand)
    (send self :labels labels)
    (send self :discard discard)))

(defmeth browser-overlay-proto :buttons (&optional (list nil set))
"Args: (&optional logical)
Sets or returns which buttons are hilited."
  (if set (setf (slot-value 'buttons) list))
  (slot-value 'buttons))

(defmeth browser-overlay-proto :justify (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether the buttons are justified (some on left, others center, others right)."
  (if set (setf (slot-value 'justify) logical))
  (slot-value 'justify))

(defmeth browser-overlay-proto :help (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether help button is to be drawn."
  (if set (setf (slot-value 'plot-help) logical))
  (slot-value 'plot-help))

(defmeth browser-overlay-proto :retain-edit (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether the retain-edit button is to be drawn."
  (if set (setf (slot-value 'retain-edit) logical))
  (slot-value 'retain-edit))

(defmeth browser-overlay-proto :edit-state (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns the state of the edit button."
  (if set (setf (slot-value 'edit-state) logical))
  (slot-value 'edit-state))

(defmeth browser-overlay-proto :expand (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether expand button is to be drawn."
  (if set (setf (slot-value 'expand) logical))
  (slot-value 'expand))

(defmeth browser-overlay-proto :format (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether format button is to be drawn."
  (if set (setf (slot-value 'format) logical))
  (slot-value 'format))

(defmeth browser-overlay-proto :labels (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether labels button is to be drawn."
  (if set (setf (slot-value 'labels) logical))
  (slot-value 'labels))


(defmeth browser-overlay-proto :discard (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether discard-close button is to be drawn."
  (if set (setf (slot-value 'discard) logical))
  (slot-value 'discard))

(defmeth browser-overlay-proto :discard-state (&optional (logical nil set))
"Args: (&optional logical)
Sets or reports the state of the discard button"
 (if set (setf (slot-value 'discard-state) logical))
  (slot-value 'discard-state))


(defmeth browser-overlay-proto :selector (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether selector button is to be drawn."
  (if set (setf (slot-value 'selector) logical))
  (slot-value 'selector))

(defmeth browser-overlay-proto :selector-state (&optional (logical nil set))
"Args: (&optional logical)
Sets or reports the state of the selector button"
 (if set (setf (slot-value 'selector-state) logical))
  (slot-value 'selector-state))

(defmeth browser-overlay-proto :switch-selector-state ()
"Args: none
Switches the state of the selector button"
  (send self :selector-state (not (send self :selector-state)))
  (send (slot-value 'graph) (send self :selector-state)))

(defmeth browser-overlay-proto :top-most (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether topmost button is to be drawn."
  (if set (setf (slot-value 'top-most) logical))
  (slot-value 'top-most))

(defmeth browser-overlay-proto :top (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether topmost button is to be drawn."
  (if set (setf (slot-value 'top-most) logical))
  (slot-value 'top-most))

(defmeth browser-overlay-proto :top-state (&optional (logical nil set))
"Args: (&optional logical)
Sets or reports the state of the top-most button."
  (when (not (send self :has-slot 'top-state))
        (send self :add-slot 'top-state))
  (if set (setf (slot-value 'top-state) logical))
  (slot-value 'top-state))

(defmeth browser-overlay-proto :switch-top-state ()
"Args: none
Switches the state of the top-most button"
  (send self :top-state (not (send self :top-state)))
  (send (slot-value 'graph) (send self :top-state)))

;MAX

(defmeth browser-overlay-proto :max (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether maximize-restore button is to be drawn."
  (if set (setf (slot-value 'maximize-button-showing) logical))
  (slot-value 'maximize-button-showing))

(defmeth browser-overlay-proto :maximize-button-showing (&optional (logical nil set))
"Args: (&optional logical)
Sets or returns whether maximize-restore button is to be drawn."
  (if set (setf (slot-value 'maximize-button-showing) logical))
  (slot-value 'maximize-button-showing))

(defmeth browser-overlay-proto :max-state (&optional (logical nil set))
"Args: (&optional logical)
Sets or reports the state of the maximize-restore button."
  (if set (setf (slot-value 'max-state) logical))
  (slot-value 'max-state))

(defmeth browser-overlay-proto :switch-max-state ()
"Args: none
Switches the state of the maximize-restore button"
  (send self :max-state (not (send self :max-state)))
  (send (slot-value 'graph) :max-restore (send self :max-state)))

(defmeth browser-overlay-proto :show-window ()
  (call-next-method)
  (send self :setup-redraw)
  (send self :redraw))
